#include <linux/init.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/uaccess.h>

MODULE_LICENSE("GPL");
MODULE_AUTHOR("Votre Nom");
MODULE_DESCRIPTION("Un module simple qui log dans /tmp/bonjour.txt");

// Fonction d'initialisation du module
static int __init bonjour_init(void)
{
    struct file *fichier;
    loff_t pos = 0;
    char *message = "Module charge - en fonction\n";
    
    printk(KERN_INFO "BonjourModule: Initialisation du module\n");
    
    // Ouvrir le fichier en écriture (création si nécessaire)
    fichier = filp_open("/tmp/bonjour.txt", O_WRONLY | O_CREAT | O_APPEND, 0644);
    
    if (IS_ERR(fichier)) {
        printk(KERN_ERR "BonjourModule: Erreur d'ouverture du fichier\n");
        return PTR_ERR(fichier);
    }
    
    // Écrire dans le fichier
    kernel_write(fichier, message, strlen(message), &pos);
    
    // Fermer le fichier
    filp_close(fichier, NULL);
    
    printk(KERN_INFO "BonjourModule: Message ecrit dans /tmp/bonjour.txt\n");
    
    return 0;
}

// Fonction de nettoyage du module
static void __exit bonjour_exit(void)
{
    struct file *fichier;
    loff_t pos = 0;
    char *message = "Module decharge - hors fonction\n";
    
    printk(KERN_INFO "BonjourModule: Dechargement du module\n");
    
    // Ouvrir le fichier en écriture
    fichier = filp_open("/tmp/bonjour.txt", O_WRONLY | O_APPEND, 0644);
    
    if (IS_ERR(fichier)) {
        printk(KERN_ERR "BonjourModule: Erreur d'ouverture du fichier a la sortie\n");
        return;
    }
    
    // Écrire dans le fichier
    kernel_write(fichier, message, strlen(message), &pos);
    
    // Fermer le fichier
    filp_close(fichier, NULL);
    
    printk(KERN_INFO "BonjourModule: Module decharge\n");
}

module_init(bonjour_init);
module_exit(bonjour_exit);