#!/bin/bash

FIFO="/dev/gpio_service"
SERVICE="gpio-service"

show_help() {
    echo "Usage: $0 {on|off|blink|status|restart|stop|start|logs|debug|help}"
    echo ""
    echo "  on, a      - Allumer GPIO17 (libgpiod)"
    echo "  off, e     - Éteindre GPIO17 (libgpiod)"  
    echo "  blink, c   - Mode clignotant (1s)"
    echo "  status, s  - État GPIO17"
    echo "  restart    - Redémarrer service"
    echo "  stop       - Arrêter service"
    echo "  start      - Démarrer service"
    echo "  logs       - Voir les logs"
    echo "  debug      - Logs debug"
    echo "  help       - Cette aide"
}

case "$1" in
    "on"|"a")
        echo "a" > $FIFO
        echo "💡 GPIO17 ALLUMÉ (libgpiod)"
        ;;
    "off"|"e") 
        echo "e" > $FIFO
        echo "⚫ GPIO17 ÉTEINT (libgpiod)"
        ;;
    "blink"|"c")
        echo "c" > $FIFO
        echo "🔁 GPIO17 CLIGNOTANT"
        ;;
    "status"|"s")
        echo "s" > $FIFO
        sleep 0.5
        sudo journalctl -u $SERVICE -n 5 --no-pager | grep -E "(GPIO17 ÉTAT:|ALLUMÉ|ÉTEINT)"
        ;;
    "restart")
        sudo systemctl restart $SERVICE
        echo "🔄 Service redémarré"
        ;;
    "stop")
        echo "q" > $FIFO 2>/dev/null || true
        sleep 1
        sudo systemctl stop $SERVICE
        echo "🛑 Service arrêté"
        ;;
    "start")
        sudo systemctl start $SERVICE
        echo "🚀 Service démarré"
        ;;
    "logs")
        sudo journalctl -u $SERVICE -n 15 --no-pager
        ;;
    "debug")
        sudo journalctl -u $SERVICE -p debug --no-pager
        ;;
    "follow")
        sudo journalctl -u $SERVICE -f
        ;;
    "service-status")
        sudo systemctl status $SERVICE --no-pager
        ;;
    "help"|"--help"|"-h")
        show_help
        ;;
    *)
        echo "❌ Commande invalide: $1"
        show_help
        exit 1
        ;;
esac
