#include <stdio.h>
#include <stdlib.h>

/**
 * modexp - Calcul rapide de l’exponentiation modulaire (base^exp mod modulo)
 * 
 * @param base La base (entier)
 * @param exp L'exposant (clé privée d)
 * @param mod Le modulo n
 * @return (base^exp) mod mod
 */
typedef unsigned short u16;
u16 modexp(u16 base, u16 exp, u16 mod) {
    u16 result = 1;
    base %= mod;
    while (exp > 0) {
        if (exp & 1) result = (result * base) % mod;
        base = (base * base) % mod;
        exp >>= 1;
    }
    return result;
}

int main(int argc, char *argv[]) {
    if (argc != 4) {
        fprintf(stderr, "Usage : %s fichier.chi d n\n", argv[0]);
        return EXIT_FAILURE;
    }

    FILE *in = fopen(argv[1], "rb");
    if (!in) {
        perror("fopen");
        return EXIT_FAILURE;
    }

    // Conversion des paramètres d et n passés en argument (clé privée)
    u16 d = (u16)atoi(argv[2]);
    u16 n = (u16)atoi(argv[3]);

    FILE *out = fopen("dechiffre.txt", "wb");
    if (!out) {
        perror("fopen output");
        fclose(in);
        return EXIT_FAILURE;
    }

    u16 chunk;
    // Lecture bloc par bloc (2 octets) du fichier chiffré
    while (fread(&chunk, sizeof(u16), 1, in) == 1) {
        // Déchiffrement RSA : m = c^d mod n
        u16 decrypted = modexp(chunk, d, n);
        fputc((char)decrypted, out);
    }

    fclose(in);
    fclose(out);
    printf("Déchiffré dans dechiffre.txt\n");
    return EXIT_SUCCESS;
}

