#include <stdio.h>
#include <stdlib.h>

typedef unsigned short u16;

/**
 * modexp - Calcul rapide de l’exponentiation modulaire (base^exp mod modulo)
 */
u16 modexp(u16 base, u16 exp, u16 mod) {
    u16 result = 1;
    base %= mod;
    while (exp > 0) {
        if (exp & 1) result = (result * base) % mod;
        base = (base * base) % mod;
        exp >>= 1;
    }
    return result;
}

int main(int argc, char *argv[]) {
    if (argc != 4) {
        fprintf(stderr, "Usage : %s fichier.txt e n\n", argv[0]);
        return EXIT_FAILURE;
    }

    u16 e = (u16)atoi(argv[2]);
    u16 n = (u16)atoi(argv[3]);

    FILE *in = fopen(argv[1], "rb");
    if (!in) {
        perror("fopen input");
        return EXIT_FAILURE;
    }

    char outname[256];
    snprintf(outname, sizeof(outname), "%s.chi", argv[1]);
    FILE *out = fopen(outname, "wb");
    if (!out) {
        perror("fopen output");
        fclose(in);
        return EXIT_FAILURE;
    }

    int ch;
    while ((ch = fgetc(in)) != EOF) {
        u16 encrypted = modexp((u16)ch, e, n);
        fwrite(&encrypted, sizeof(u16), 1, out);
    }

    fclose(in);
    fclose(out);
    printf("Fichier chiffré : %s\n", outname);
    return EXIT_SUCCESS;
}

